<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('batch_stock_movements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('batch_id')->constrained('product_batches')->cascadeOnDelete();
            $table->foreignId('product_id')->constrained('products')->cascadeOnDelete();
            
            // Movement Details
            $table->enum('movement_type', ['in', 'out', 'adjustment', 'transfer'])->index();
            $table->integer('quantity')->default(0);
            $table->integer('quantity_before')->default(0);
            
            // Reference Information
            $table->string('reference_type')->nullable();
            $table->unsignedBigInteger('reference_id')->nullable();
            $table->string('reference_number')->nullable()->index();
            
            // Reason and Notes
            $table->string('reason')->nullable();
            $table->text('notes')->nullable();
            
            // User Information
            $table->foreignId('user_id')->nullable()->constrained('users')->nullOnDelete();
            
            $table->timestamps();
            
            // Indexes
            $table->index(['batch_id', 'movement_type']);
            $table->index(['product_id', 'created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('batch_stock_movements');
    }
};