<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {

            // Expiry & Batch Tracking Fields
            $table->boolean('has_expiry')->default(false)->after('manage_batch_numbers');
            $table->boolean('track_batches')->default(false)->after('has_expiry');
            $table->integer('expiry_warning_days')->default(30)->after('track_batches');
            $table->string('expiry_alert_level')->default('warning')->after('expiry_warning_days');

            // Reference Fields
            $table->string('ref_number')->nullable()->unique()->after('barcode');
            $table->string('supplier_ref')->nullable()->after('ref_number');
            $table->string('manufacturer_ref')->nullable()->after('supplier_ref');

            // Indexes
            $table->index(['has_expiry', 'track_batches']);
            $table->index(['ref_number']);
        });
    }

    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {

            // Drop only fields added by THIS migration
            $table->dropColumn([
                'has_expiry',
                'track_batches',
                'expiry_warning_days',
                'expiry_alert_level',
                'ref_number',
                'supplier_ref',
                'manufacturer_ref',
            ]);

            // Drop indexes
            $table->dropIndex(['has_expiry', 'track_batches']);
            $table->dropIndex(['ref_number']);
        });
    }
};
