<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->string('contact_person')->nullable()->after('address');
            $table->string('customer_type')->default('regular')->after('contact_person'); // regular, business, walk-in
            $table->string('company_name')->nullable()->after('customer_type');
            $table->string('website')->nullable()->after('company_name');
            $table->string('tax_id')->nullable()->after('website');
            $table->enum('status', ['active', 'inactive'])->default('active')->after('tax_id');
            $table->decimal('credit_limit', 12, 2)->nullable()->after('status');
            $table->decimal('balance', 12, 2)->default(0)->after('credit_limit');
            $table->decimal('total_spent', 12, 2)->default(0)->after('balance');
            $table->integer('total_orders')->default(0)->after('total_spent');
            $table->date('last_purchase_date')->nullable()->after('total_orders');
            $table->text('notes')->nullable()->after('last_purchase_date');
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::table('customers', function (Blueprint $table) {
            $table->dropColumn([
                'contact_person',
                'customer_type',
                'company_name',
                'website',
                'tax_id',
                'status',
                'credit_limit',
                'balance',
                'total_spent',
                'total_orders',
                'last_purchase_date',
                'notes',
                'deleted_at'
            ]);
        });
    }
};