<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('payment_methods', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique(); // cash, bank, cod, mpesa
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });

        // Seed defaults
        DB::table('payment_methods')->insert([
            ['name' => 'cash'],
            ['name' => 'bank'],
            ['name' => 'cod'],
            ['name' => 'mpesa'], // Will be used later
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('payment_methods');
    }
};
