<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('purchase_items', function (Blueprint $table) {
            $table->id();
            
            // Relationships
            $table->foreignId('purchase_id')->constrained()->cascadeOnDelete();
            $table->foreignId('product_id')->constrained()->cascadeOnDelete();
            
            // Item Details
            $table->enum('item_type', ['product', 'service'])->default('product');
            $table->text('description')->nullable();
            
            // Quantity and Pricing
            $table->decimal('quantity', 10, 3)->default(0);
            $table->decimal('unit_price', 12, 2)->default(0);
            $table->decimal('tax_percent', 5, 2)->default(0);
            $table->decimal('tax_amount', 12, 2)->default(0);
            $table->decimal('discount_percent', 5, 2)->default(0);
            $table->decimal('discount_amount', 12, 2)->default(0);
            $table->decimal('total', 12, 2)->default(0);
            
            // Batch/Expiry Information
            $table->string('batch_number')->nullable();
            $table->date('expiry_date')->nullable();
            
            // Stock Management
            $table->boolean('added_to_stock')->default(false);
            
            // Additional
            $table->text('notes')->nullable();
            
            $table->timestamps();
            
            // Indexes
            $table->index('purchase_id');
            $table->index('product_id');
            $table->index('batch_number');
            $table->index('expiry_date');
            $table->index('added_to_stock');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('purchase_items');
    }
};