<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('purchases', function (Blueprint $table) {
            $table->id();
            
            // Supplier Information
            $table->foreignId('supplier_id')->nullable()->constrained()->nullOnDelete();
            
            // Purchase Details
            $table->string('invoice_no')->unique();
            $table->date('purchase_date');
            $table->string('reference_number')->nullable();
            $table->date('expected_delivery_date')->nullable();
            
            // Pricing
            $table->decimal('subtotal', 12, 2)->default(0);
            $table->decimal('discount_amount', 12, 2)->default(0);
            $table->decimal('tax_amount', 12, 2)->default(0);
            $table->decimal('shipping_charges', 12, 2)->default(0);
            $table->decimal('grand_total', 12, 2)->default(0);
            
            // Payment Information
            $table->decimal('paid_amount', 12, 2)->default(0);
            $table->enum('payment_status', ['pending', 'partial', 'paid'])->default('pending');
            $table->string('payment_method')->nullable();
            $table->text('payment_notes')->nullable();
            
            // Status
            $table->enum('status', ['draft', 'pending', 'completed', 'cancelled'])->default('draft');
            
            // Additional Information
            $table->text('notes')->nullable();
            $table->text('terms_conditions')->nullable();
            
            // Audit
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('updated_by')->nullable()->constrained('users')->nullOnDelete();
            
            $table->timestamps();
            $table->softDeletes();
            
            // Indexes
            $table->index('invoice_no');
            $table->index('purchase_date');
            $table->index('status');
            $table->index('payment_status');
            $table->index(['supplier_id', 'purchase_date']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('purchases');
    }
};