<?php
namespace App\Services;

use SimpleSoftwareIO\QrCode\Facades\QrCode;
use Illuminate\Support\Facades\Storage;

class QrService
{
    /**
     * Generate and store a QR image from string payload
     */
    public function generateAndStore(string $payload, string $path = 'qrcodes/', int $size = 300): string
    {
        $img = QrCode::format('png')->size($size)->generate($payload);
        $filename = $path . uniqid('qr_') . '.png';
        Storage::disk('public')->put($filename, $img);
        return $filename;
    }
}
