<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StoreInformation extends Model
{
    use HasFactory;

    protected $table = 'store_information';

    protected $fillable = [
        'store_name',
        'logo',
        'whatsapp_number',
        'telephone',
        'address',
        'company_pin',
        'email',
        'city',
        'country',
        'currency',
        'timezone',
        'vat_number',
        'branch_code',
        'business_registration',
        'kra_pin',
        'permit_number',
        'business_hours',
    ];

    protected $casts = [
        'business_hours' => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the logo URL attribute
     */
        public function getLogoUrlAttribute()
        {
            if (!$this->logo) {
                return null;
            }

            if (filter_var($this->logo, FILTER_VALIDATE_URL)) {
                return $this->logo;
            }
            
            // Always return the full storage path
            return asset('storage/store/logos/' . $this->logo);
        }

    /**
     * Get the business hours as formatted string
     */
    public function getBusinessHoursFormattedAttribute()
    {
        $hours = $this->business_hours;
        if ($hours && isset($hours['open']) && isset($hours['close'])) {
            return "{$hours['open']} - {$hours['close']}";
        }
        return '08:00 - 20:00';
    }

    /**
     * Get full address
     */
    public function getFullAddressAttribute()
    {
        $parts = [];
        if ($this->address) $parts[] = $this->address;
        if ($this->city) $parts[] = $this->city;
        if ($this->country) $parts[] = $this->country;
        
        return implode(', ', $parts);
    }

    /**
     * Get contact information as array
     */
    public function getContactInfo()
    {
        return [
            'phone' => $this->telephone,
            'whatsapp' => $this->whatsapp_number,
            'email' => $this->email,
            'address' => $this->full_address,
            'logo' => $this->logo_url,
        ];
    }
}