<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReceiptSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'paper_size',
        'chars_per_line',
        'encoding',
        'auto_cut',
        'auto_open_drawer',
        'print_store_logo',
        'logo_path',
        'print_store_name',
        'print_store_address',
        'print_store_phone',
        'print_vat_number',
        'print_branch_code',
        'print_cashier_name',
        'print_date_time',
        'print_transaction_number',
        'print_customer_info',
        'print_item_barcode',
        'print_qr_code',
        'qr_code_type',
        'print_tax_breakdown',
        'print_discounts',
        'print_payment_method',
        'print_change_amount',
        'footer_text',
        'print_footer',
        'copies',
        'is_default',
        'is_active',
        'custom_settings'
    ];

    protected $casts = [
        'auto_cut' => 'boolean',
        'auto_open_drawer' => 'boolean',
        'print_store_logo' => 'boolean',
        'print_store_name' => 'boolean',
        'print_store_address' => 'boolean',
        'print_store_phone' => 'boolean',
        'print_vat_number' => 'boolean',
        'print_branch_code' => 'boolean',
        'print_cashier_name' => 'boolean',
        'print_date_time' => 'boolean',
        'print_transaction_number' => 'boolean',
        'print_customer_info' => 'boolean',
        'print_item_barcode' => 'boolean',
        'print_qr_code' => 'boolean',
        'print_tax_breakdown' => 'boolean',
        'print_discounts' => 'boolean',
        'print_payment_method' => 'boolean',
        'print_change_amount' => 'boolean',
        'print_footer' => 'boolean',
        'is_default' => 'boolean',
        'is_active' => 'boolean',
        'custom_settings' => 'array',
    ];

    /**
     * Get the default receipt setting
     */
    public static function getDefault()
    {
        return self::where('is_default', true)->where('is_active', true)->first();
    }

    /**
     * Get active receipt settings
     */
    public static function getActive()
    {
        return self::where('is_active', true)->get();
    }

    /**
     * Get formatted settings for receipt generation
     */
    public function getFormattedSettings()
    {
        return [
            'paper' => [
                'size' => $this->paper_size,
                'chars_per_line' => $this->chars_per_line,
                'encoding' => $this->encoding,
            ],
            'printer' => [
                'auto_cut' => $this->auto_cut,
                'auto_open_drawer' => $this->auto_open_drawer,
                'copies' => $this->copies,
            ],
            'header' => [
                'print_logo' => $this->print_store_logo,
                'logo_path' => $this->logo_path,
                'print_name' => $this->print_store_name,
                'print_address' => $this->print_store_address,
                'print_phone' => $this->print_store_phone,
                'print_vat' => $this->print_vat_number,
                'print_branch' => $this->print_branch_code,
            ],
            'body' => [
                'print_cashier' => $this->print_cashier_name,
                'print_datetime' => $this->print_date_time,
                'print_transaction_no' => $this->print_transaction_number,
                'print_customer' => $this->print_customer_info,
                'print_item_barcode' => $this->print_item_barcode,
                'print_qr_code' => $this->print_qr_code,
                'qr_code_type' => $this->qr_code_type,
                'print_tax' => $this->print_tax_breakdown,
                'print_discounts' => $this->print_discounts,
            ],
            'footer' => [
                'print_payment_method' => $this->print_payment_method,
                'print_change' => $this->print_change_amount,
                'print_footer' => $this->print_footer,
                'footer_text' => $this->footer_text,
            ],
            'custom' => $this->custom_settings ?? [],
        ];
    }
}