<?php
namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PosCheckoutRequest extends FormRequest
{
    public function authorize() { return $this->user() !== null; }

    public function rules() {
        return [
            'items'=>'required|array|min:1',
            'items.*.product_id'=>'required|integer|exists:products,id',
            'items.*.qty'=>'required|integer|min:1',
            'items.*.unit_price'=>'required|numeric|min:0',
            'payment_method_id'=>'nullable|exists:payment_methods,id',
            'payment_amount'=>'nullable|numeric|min:0'
        ];
    }
}
