<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SaleItem;
use App\Models\Sale;
use Carbon\Carbon;
use DB;

class ReportController extends Controller
{
    public function index(Request $req)
    {
        $from = $req->query('from', Carbon::now()->subMonth()->startOfDay());
        $to = $req->query('to', Carbon::now()->endOfDay());

        $topSellers = SaleItem::select('product_id', DB::raw('SUM(qty) as qty_sold'), DB::raw('SUM(total) as revenue'))
            ->whereHas('sale', fn($q)=>$q->whereBetween('created_at', [$from, $to])->where('status','completed'))
            ->groupBy('product_id')->orderByDesc('qty_sold')->with('product')->limit(50)->get();

        $salesByUser = Sale::select('user_id', DB::raw('COUNT(*) as sales_count'), DB::raw('SUM(grand_total) as total_sales'))
            ->whereBetween('created_at', [$from, $to])->groupBy('user_id')->with('user')->get();

        return view('reports.index', compact('topSellers','salesByUser','from','to'));
    }
}
