<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class MpesaController extends Controller
{
    /**
     * Display M-Pesa configuration page
     */
    public function configuration()
    {
        return view('mpesa.configuration');
    }
    
    /**
     * Update M-Pesa configuration
     */
    public function updateConfiguration(Request $request)
    {
        $validated = $request->validate([
            'consumer_key' => 'required|string',
            'consumer_secret' => 'required|string',
            'shortcode' => 'required|string',
            'passkey' => 'required|string',
            'environment' => 'required|in:sandbox,production',
            'callback_url' => 'required|url',
        ]);
        
        // Save configuration (you can use database or config file)
        // This is a simplified example
        $config = [
            'mpesa' => $validated
        ];
        
        // Save to database or config
        // For now, we'll just return success
        
        return response()->json([
            'success' => true,
            'message' => 'Configuration updated successfully'
        ]);
    }
    
    /**
     * Test M-Pesa connection
     */
    public function testConnection(Request $request)
    {
        try {
            // This is a simplified test
            // In production, you would make an actual API call to M-Pesa
            
            return response()->json([
                'success' => true,
                'message' => 'Connection test successful'
            ]);
            
        } catch (\Exception $e) {
            Log::error('M-Pesa connection test error: ' . $e->getMessage());
            return response()->json([
                'success' => false,
                'error' => 'Connection test failed: ' . $e->getMessage()
            ], 500);
        }
    }
    
    /**
     * Display M-Pesa settings page
     */
    public function settings()
    {
        return view('mpesa.settings');
    }
    
    /**
     * Update M-Pesa settings
     */
    public function updateSettings(Request $request)
    {
        $validated = $request->validate([
            'auto_check_payments' => 'boolean',
            'auto_check_minutes' => 'integer|min:1|max:60',
            'auto_match_payments' => 'boolean',
            'notification_email' => 'nullable|email',
            'daily_report_time' => 'nullable|date_format:H:i',
        ]);
        
        // Save settings
        // This is a simplified example
        
        return response()->json([
            'success' => true,
            'message' => 'Settings updated successfully'
        ]);
    }
    
    /**
     * Display M-Pesa test page
     */
    public function testPage()
    {
        return view('mpesa.test');
    }
}