<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CheckDatabaseSchema extends Command
{
    protected $signature = 'db:check-schema';
    protected $description = 'Check database schema for missing columns';

    public function handle()
    {
        $this->info('Checking database schema...');
        
        // Check products table
        $productsColumns = Schema::getColumnListing('products');
        $this->table(['Column', 'Exists'], array_map(function($column) {
            return [$column, '✓'];
        }, $productsColumns));
        
        // Check categories table
        $categoriesColumns = Schema::getColumnListing('categories');
        $this->info("\nCategories table columns:");
        $this->table(['Column', 'Exists'], array_map(function($column) {
            return [$column, '✓'];
        }, $categoriesColumns));
        
        // Check for required columns
        $requiredColumns = ['name', 'price', 'sku', 'status', 'category_id'];
        $missingColumns = [];
        
        foreach ($requiredColumns as $column) {
            if (!in_array($column, $productsColumns)) {
                $missingColumns[] = [$column, '✗'];
            }
        }
        
        if (!empty($missingColumns)) {
            $this->error('Missing required columns in products table:');
            $this->table(['Column', 'Exists'], $missingColumns);
        } else {
            $this->info('All required columns exist in products table.');
        }
        
        return 0;
    }
}